"""autocomplete_scraper.py
Simple script to retrieve Google Autocomplete suggestions using the public suggest endpoint.
Note: This is intended for educational / prototyping use. For heavy use, respect terms of service
and consider official APIs or rate-limiting headers.
"""
import requests
import urllib.parse
import time

def get_google_autocomplete(query, country='us', language='en'):
    url = "https://suggestqueries.google.com/complete/search"
    params = {
        'client': 'firefox',
        'q': query,
        'hl': language,
        'gl': country.upper()
    }
    resp = requests.get(url, params=params, timeout=10)
    resp.raise_for_status()
    # Response is JSONP-like: [query, [suggestions...], ...]
    data = resp.json()
    suggestions = data[1]
    return suggestions

if __name__ == '__main__':
    seed = input('Seed query: ').strip()
    suggestions = get_google_autocomplete(seed)
    print('\n'.join(suggestions))