# ahrefs_api_connector.py
# Ahrefs API connector template - by 索未 · suowei.pub
# Usage: python ahrefs_api_connector.py "domain"
import requests
import pandas as pd
import sys

API_TOKEN = 'YOUR_AHREFS_API_TOKEN'
BASE_URL = 'https://apiv2.ahrefs.com'

def get_site_overview(domain):
    params = {
        'token': API_TOKEN,
        'from': 'domain_rating',
        'target': domain,
        'mode': 'domain',
        'output': 'json'
    }
    resp = requests.get(BASE_URL, params=params)
    if resp.status_code == 200:
        data = resp.json()
        df = pd.DataFrame([data])
        df.to_excel(f'ahrefs_{domain}_overview.xlsx', index=False)
        print(f'✅ Site overview for {domain} saved.')
    else:
        raise Exception(f'Ahrefs API error: {resp.status_code}')

if __name__ == '__main__':
    domain = sys.argv[1] if len(sys.argv) > 1 else 'example.com'
    get_site_overview(domain)
