# rank_tracker_merger.py
# Merge Ahrefs Rank Tracker and GSC data - by 索未 · suowei.pub
import pandas as pd

def merge_rank_data(ahrefs_csv, gsc_csv):
    df_ahrefs = pd.read_csv(ahrefs_csv)
    df_gsc = pd.read_csv(gsc_csv)
    merged = pd.merge(df_ahrefs, df_gsc, on='Keyword', how='outer')
    merged['CTR'] = (merged.get('Clicks', 0) / merged.get('Impressions', 1)) * 100
    merged.to_excel('rank_tracker_merged.xlsx', index=False)
    print('✅ rank_tracker_merged.xlsx generated')

if __name__ == '__main__':
    print('⚙️ rank_tracker_merger template ready.')
