# semantic_cluster_builder.py
# Build keyword semantic clusters using TF-IDF and KMeans - by 索未 · suowei.pub
import pandas as pd
from sklearn.feature_extraction.text import TfidfVectorizer
from sklearn.cluster import KMeans

def build_clusters(keyword_list, n_clusters=5):
    vectorizer = TfidfVectorizer(stop_words='english', ngram_range=(1,2))
    X = vectorizer.fit_transform(keyword_list)
    model = KMeans(n_clusters=n_clusters, random_state=42)
    model.fit(X)
    clusters = pd.DataFrame({'Keyword': keyword_list, 'Cluster': model.labels_})
    clusters.to_excel('keyword_clusters.xlsx', index=False)
    print('✅ keyword_clusters.xlsx generated')

if __name__ == '__main__':
    kws = ["ai seo","backlink strategy","content marketing","link building","seo audit"]
    build_clusters(kws, n_clusters=3)
