# === AI Predictive Script ===
# SEO意图预测脚本
# by 索未 · suowei.pub

import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.ensemble import RandomForestRegressor
from sklearn.metrics import mean_absolute_error, r2_score
import joblib

df = pd.read_excel("Telemetry_Intent_Map.xlsx")

X = df[["Avg. Engagement Time (s)", "Scroll Depth (%)", "Clicks per Session", "Conversion Rate (%)"]]
y = df["Intent Score"]

X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state=42)

model = RandomForestRegressor(n_estimators=200, random_state=42)
model.fit(X_train, y_train)

y_pred = model.predict(X_test)
mae = mean_absolute_error(y_test, y_pred)
r2 = r2_score(y_test, y_pred)
print(f"✅ 模型训练完成 | MAE={mae:.2f} | R²={r2:.2f}")

joblib.dump(model, "intent_predictor_model.pkl")
print("✅ 模型已保存为 intent_predictor_model.pkl")

new_data = pd.DataFrame({
    "Avg. Engagement Time (s)": [72, 90],
    "Scroll Depth (%)": [80, 95],
    "Clicks per Session": [1.5, 3.2],
    "Conversion Rate (%)": [2.0, 4.5]
})
pred = model.predict(new_data)
new_data["Predicted Intent Score"] = [round(x, 1) for x in pred]
print(new_data)

new_data.to_csv("predicted_intent_scores.csv", index=False)
print("📊 预测结果已导出：predicted_intent_scores.csv")
