# Auto_Sync_Sheet_Script.py
# Write CSV data into Google Sheet for Looker Studio consumption
# by 索未 · suowei.pub

from googleapiclient.discovery import build
from google.oauth2 import service_account
import pandas as pd

SERVICE_ACCOUNT_FILE = 'service_account.json'  # Service account with Sheets access
SPREADSHEET_ID = 'YOUR_SHEET_ID'  # replace with your Google Sheet ID
RANGE = 'GSC_Data!A1'

creds = service_account.Credentials.from_service_account_file(
    SERVICE_ACCOUNT_FILE, scopes=['https://www.googleapis.com/auth/spreadsheets'])
sheets_service = build('sheets', 'v4', credentials=creds)

df = pd.read_csv('gsc_query_data.csv')
values = [df.columns.tolist()] + df.values.tolist()
body = {'values': values}
sheets_service.spreadsheets().values().update(
    spreadsheetId=SPREADSHEET_ID,
    range=RANGE,
    valueInputOption='RAW',
    body=body
).execute()
print('✅ GSC data synced to Google Sheet.')
