# GSC_API_Fetch_Script.py
# Fetch GSC query/page performance data and save to CSV
# by 索未 · suowei.pub

from googleapiclient.discovery import build
from google.oauth2 import service_account
import pandas as pd
from datetime import date, timedelta

SCOPES = ['https://www.googleapis.com/auth/webmasters.readonly']
SERVICE_ACCOUNT_FILE = 'service_account.json'  # replace with your file
PROPERTY_URI = 'https://example.com/'

creds = service_account.Credentials.from_service_account_file(
    SERVICE_ACCOUNT_FILE, scopes=SCOPES)
service = build('searchconsole', 'v1', credentials=creds)

start_date = (date.today() - timedelta(days=30)).isoformat()
end_date = date.today().isoformat()

request = {
    'startDate': start_date,
    'endDate': end_date,
    'dimensions': ['query', 'page'],
    'rowLimit': 2500
}
response = service.searchanalytics().query(siteUrl=PROPERTY_URI, body=request).execute()
rows = response.get('rows', [])
data = []
for r in rows:
    keys = r.get('keys', [])
    query = keys[0] if len(keys) > 0 else ''
    page = keys[1] if len(keys) > 1 else ''
    data.append({
        'Query': query,
        'Page': page,
        'Clicks': r.get('clicks',0),
        'Impressions': r.get('impressions',0),
        'CTR (%)': round(r.get('ctr',0)*100,2),
        'Position': round(r.get('position',0),2)
    })
df = pd.DataFrame(data)
df.to_csv('gsc_query_data.csv', index=False)
print('✅ gsc_query_data.csv exported, rows:', len(df))
