# ai_predictive_integration.py
# Load predictions and merge with GSC + Intent Map for dashboard ingestion
# by 索未 · suowei.pub

import pandas as pd

df_gsc = pd.read_csv('gsc_query_data.csv')
df_intent = pd.read_excel('Telemetry_Intent_Map.xlsx')
df_pred = pd.read_csv('predicted_intent_scores.csv')

# Merge: prefer predicted intent for new queries, else use existing Intent Score
merged = pd.merge(df_gsc, df_intent[['Query','Intent Score']], on='Query', how='left')
merged = pd.merge(merged, df_pred[['Query','Predicted Intent Score']], on='Query', how='left')

merged['Final Intent Score'] = merged['Predicted Intent Score'].fillna(merged['Intent Score'])
merged.to_csv('gsc_intent_merged.csv', index=False)
print('✅ Merged GSC + Intent + Predictive -> gsc_intent_merged.csv')
