# moz_api_connector.py
# Moz API connector template - by 索未 · suowei.pub
# NOTE: Replace ACCESS_ID and SECRET_KEY with your Moz API credentials.
# Documentation: https://moz.com/products/api

import hashlib, hmac, base64, time, requests
import pandas as pd
import sys
from urllib.parse import quote_plus

ACCESS_ID = "YOUR_MOZ_ACCESS_ID"
SECRET_KEY = "YOUR_MOZ_SECRET_KEY"
BASE_URL = "https://lsapi.seomoz.com/linkscape/"

def get_auth_headers():
    expires = int(time.time()) + 300
    string_to_sign = ACCESS_ID + "\n" + str(expires)
    signature = base64.b64encode(hmac.new(SECRET_KEY.encode('utf-8'), string_to_sign.encode('utf-8'), hashlib.sha1).digest()).decode('utf-8')
    return {"Authorization": "AccessID {}; Expires {}; Signature {}".format(ACCESS_ID, expires, signature)}

def get_url_metrics(urls):
    # urls: list of URLs
    endpoint = BASE_URL + "url-metrics/"
    resp = requests.post(endpoint, headers=get_auth_headers(), json={"targets": urls})
    if resp.status_code == 200:
        data = resp.json()
        df = pd.json_normalize(data)
        df.to_excel("moz_url_metrics.xlsx", index=False)
        print("✅ moz_url_metrics.xlsx saved")
    else:
        print("❌ Moz API error:", resp.status_code, resp.text)

if __name__ == '__main__':
    if len(sys.argv) > 1:
        urls = sys.argv[1:]
    else:
        urls = ["https://example.com"]
    get_url_metrics(urls)
