# mobile_serp_diff.py
# Compare mobile vs desktop SERP rankings exported from Rank Ranger and highlight significant differences
# by 索未 · suowei.pub
import pandas as pd

def compare_mobile_desktop(mobile_csv='mobile_rankings.csv', desktop_csv='desktop_rankings.csv', output_excel='mobile_desktop_diff.xlsx', threshold=3):
    m = pd.read_csv(mobile_csv)
    d = pd.read_csv(desktop_csv)
    # expect columns: Keyword, URL, Rank
    m = m.rename(columns={'Rank':'Mobile Rank','URL':'Mobile URL'})
    d = d.rename(columns={'Rank':'Desktop Rank','URL':'Desktop URL'})
    merged = pd.merge(m, d, on='Keyword', how='outer', suffixes=('_m','_d')).fillna(999)
    merged['Rank Diff'] = merged['Desktop Rank'] - merged['Mobile Rank']
    merged['Significant'] = merged['Rank Diff'].abs() >= threshold
    merged.sort_values(by='Rank Diff', ascending=False, inplace=True)
    merged.to_excel(output_excel, index=False)
    print(f'✅ Mobile/Desktop diff report saved to {output_excel} (threshold={threshold})')

if __name__ == '__main__':
    compare_mobile_desktop()
