# nlq_export.py
# Export Natural Language Question (NLQ) keyword sets from Rank Ranger exports or keyword lists
# by 索未 · suowei.pub
import pandas as pd
import re

def extract_nlq_from_keywords(input_csv='keywords.csv', output_csv='nlq_questions.csv'):
    df = pd.read_csv(input_csv)
    # assume column 'keyword' exists
    def is_question(k):
        k = str(k).strip().lower()
        return any(k.startswith(p) for p in ('how','why','what','when','where','who','is','does','can','should')) or '?' in k
    df['is_question'] = df['keyword'].apply(is_question)
    nlq = df[df['is_question']]
    nlq.to_csv(output_csv, index=False)
    print(f'✅ {len(nlq)} NLQ extracted to {output_csv}')

if __name__ == '__main__':
    extract_nlq_from_keywords()
