# rankranger_api_connector.py
# Rank Ranger API connector template - by 索未 · suowei.pub
# NOTE: Replace API_KEY and configure account/project IDs per Rank Ranger API docs.
# Rank Ranger API docs: https://www.rankranger.com/api-documentation

import requests
import pandas as pd
import sys

API_KEY = 'YOUR_RANKRANGER_API_KEY'
BASE_URL = 'https://api.rankranger.com/'
# Example function to get keyword ranking data (adjust params per API)
def get_rankings(project_id, start_date=None, end_date=None, device='desktop'):
    params = {
        'api_key': API_KEY,
        'project_id': project_id,
        'start_date': start_date,
        'end_date': end_date,
        'device': device,
        'output': 'json'
    }
    resp = requests.get(BASE_URL + 'get_keyword_ranking', params=params)
    if resp.status_code == 200:
        data = resp.json()
        df = pd.json_normalize(data.get('data', []))
        return df
    else:
        raise Exception(f'Rank Ranger API error: {resp.status_code} - {resp.text}')

if __name__ == '__main__':
    project = sys.argv[1] if len(sys.argv) > 1 else 'your_project_id'
    df = get_rankings(project, start_date=None, end_date=None, device='mobile')
    df.to_excel(f'rankranger_{project}_rankings.xlsx', index=False)
    print('✅ rankranger rankings exported to Excel')
