# multimodal_schema_generator.py
# Generate schema for image, video, audio (multimodal) - by 索未 · suowei.pub
import json
def generate_multimodal_schema(media_type, name, url, desc, date_published, thumbnail, transcript=None):
    schema = {
        "@context": "https://schema.org",
        "@type": f"{media_type.capitalize()}Object",
        "name": name,
        "description": desc,
        "contentUrl": url,
        "thumbnailUrl": thumbnail,
        "uploadDate": date_published,
        "publisher": {"@type": "Organization", "name": "索未（Suowei）", "url": "https://suowei.pub"},
    }
    if transcript:
        schema["transcript"] = transcript
    filename = f"{media_type}_schema.json"
    with open(filename, "w", encoding="utf-8") as f:
        json.dump(schema, f, ensure_ascii=False, indent=2)
    print("✅", filename, "generated")

if __name__ == '__main__':
    generate_multimodal_schema(
        "video",
        "AI SEO优化指南",
        "https://suowei.pub/video/ai-seo.mp4",
        "索未讲解AI内容优化与Agent搜索策略",
        "2025-11-05",
        "https://suowei.pub/thumb.jpg",
        transcript="In this video, Suowei explains how AI agents index structured content..."
    )
