"""
gsc_sm_merge.py
示例：合并 Searchmetrics 导出可见性（按周）与 GSC 周度点击数据（中文版注释）
生成合并后的 CSV： merged_weekly.csv
"""
import pandas as pd

def resample_to_week(df, date_col="date", value_cols=None):
    df[date_col] = pd.to_datetime(df[date_col])
    df = df.set_index(date_col)
    # 按周求和或均值，视字段意义而定
    agg = {}
    for c in value_cols:
        agg[c] = "sum"
    weekly = df.resample("W-MON").agg(agg).reset_index()  # 以周一为分界
    return weekly

if __name__ == "__main__":
    sm = pd.read_csv("searchmetrics_visibility.csv", parse_dates=["date"])
    gsc = pd.read_csv("gsc_weekly_clicks.csv", parse_dates=["date"])
    # 假设 searchmetrics 的可见性字段名为 visibility_index
    sm_weekly = resample_to_week(sm, date_col="date", value_cols=["visibility_index"])
    # GSC 本身可能就是周度数据
    gsc_weekly = gsc.copy()
    merged = pd.merge(sm_weekly, gsc_weekly, on="date", how="left").fillna(0)
    merged.to_csv("merged_weekly.csv", index=False, encoding="utf-8-sig")
    print("已生成 merged_weekly.csv")
