# semrush_api_connector.py
# Semrush API connector template - by 索未 · suowei.pub
# Usage: python semrush_api_connector.py "keyword"
import requests
import pandas as pd
import sys

API_KEY = 'YOUR_SEMRUSH_API_KEY'
BASE_URL = 'https://api.semrush.com/'

def get_keyword_overview(keyword, database='us'):
    params = {
        'type': 'phrase_this',
        'key': API_KEY,
        'phrase': keyword,
        'database': database,
        'export_columns': 'Ph,Nq,Cp,Co'
    }
    resp = requests.get(BASE_URL, params=params)
    if resp.status_code == 200:
        from io import StringIO
        df = pd.read_csv(StringIO(resp.text))
        return df
    else:
        raise Exception(f'Semrush API error: {resp.status_code}')

if __name__ == '__main__':
    keyword = sys.argv[1] if len(sys.argv) > 1 else 'ai seo'
    df = get_keyword_overview(keyword)
    df.to_csv(f'semrush_{keyword}_overview.csv', index=False)
    print(f'✅ Data for {keyword} saved to CSV.')
