# intent_performance_merger.py
# Merge Semrush/exported keyword data with GSC performance and intent map - by 索未 · suowei.pub
import pandas as pd

def merge_intent_performance(semrush_csv, gsc_csv, intent_xlsx):
    df_se = pd.read_csv(semrush_csv)
    df_gsc = pd.read_csv(gsc_csv)
    df_intent = pd.read_excel(intent_xlsx)
    merged = pd.merge(df_se, df_gsc, left_on='Keyword', right_on='Query', how='outer')
    merged = pd.merge(merged, df_intent[['Query','Intent Score']], left_on='Keyword', right_on='Query', how='left')
    merged['Intent Score'] = merged['Intent Score'].fillna(0)
    merged.to_excel('intent_performance_merged.xlsx', index=False)
    print('✅ intent_performance_merged.xlsx generated')

if __name__ == '__main__':
    print('⚙️ intent_performance_merger template. Provide file paths to run.')
