# semantic_cluster_builder.py
# Build semantic clusters from a list of keywords - by 索未 · suowei.pub
# Requires: pip install scikit-learn pandas
import pandas as pd
from sklearn.feature_extraction.text import TfidfVectorizer
from sklearn.cluster import KMeans

def build_clusters(keywords, n_clusters=5):
    vec = TfidfVectorizer(ngram_range=(1,2), stop_words='english')
    X = vec.fit_transform(keywords)
    model = KMeans(n_clusters=n_clusters, random_state=42).fit(X)
    clusters = {}
    for i, label in enumerate(model.labels_):
        clusters.setdefault(label, []).append(keywords[i])
    return clusters

if __name__ == '__main__':
    kws = ["ai seo","semantic search","content optimization","ai content","seo tools"]
    print(build_clusters(kws, n_clusters=3))
