# suowei_youtube_seo_toolkit_pro

完整版（含依赖包说明、真实 YouTube Data API 调用模板、示例数据与自动报表脚本）
本工具包提供了可直接运行的示例代码。**使用前请按 README 中说明配置 API 凭证与依赖环境。**

## 包含内容（概要）
- `requirements.txt` — Python 依赖
- `setup.sh` — 一键创建虚拟环境并安装依赖（Linux / macOS）
- `config_example.json` — API Key / OAuth / channel_id 示例
- `youtube_api_fetcher.py` — 使用 YouTube Data API v3 拉取频道与视频数据（支持 API Key 或 OAuth）
- `metadata_generator.py` — 元数据自动生成示例（模板，支持接入 OpenAI）
- `subtitle_optimizer.py` — 通过字幕提取关键词并生成 SEO 建议
- `retention_analyzer.py` — 基于示例观看会话数据生成留存分析与图表
- `auto_report.py` — 周报/月报自动生成（包含 Excel、图表）
- `keyword_research_template.csv` — 关键词研究模板
- `example_data/` — 示例数据（sample_videos.csv, sample_subtitles.srt, sample_watch_sessions.csv）
- `LICENSE` — MIT

## 快速开始（最少步骤）
1. 复制 `config_example.json` 为 `config.json` 并填入你的 `API_KEY` 或 OAuth 信息与 `CHANNEL_ID`。
2. 在终端运行（linux/macOS）:
   ```bash
   bash setup.sh
   source .venv/bin/activate
   python youtube_api_fetcher.py --config config.json --out example_data/fetched_videos.csv
   python metadata_generator.py --in example_data/fetched_videos.csv --out example_data/metadata_suggestions.csv
   python subtitle_optimizer.py --srt example_data/sample_subtitles.srt --out example_data/subtitle_keywords.csv
   python retention_analyzer.py --in example_data/sample_watch_sessions.csv --out example_data/retention_report.xlsx
   python auto_report.py --video_csv example_data/fetched_videos.csv --watch_csv example_data/sample_watch_sessions.csv --out report_weekly.xlsx
   ```
3. 查看 `report_weekly.xlsx` 与生成的图表（PNG）文件。

## 注意
- YouTube Data API 配额与 OAuth 设置请在 Google Cloud Console 完成。`youtube_api_fetcher.py` 同时支持简单 API Key 拉取（适用于公共数据）与 OAuth 授权（适用于访问私有数据 / 更复杂权限）。
- `metadata_generator.py` 提供接入示例（如 OpenAI），请自行配置 API Key（该工具包不包含第三方 API Key）。
- 示例数据仅用于演示，真实使用请用你自己的频道/视频数据。

